import 'dart:convert';

import 'package:flutter/material.dart' as material;
import 'package:get/get.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/nominee/nominee_controller.dart';
import 'package:viserpay/data/model/authorization/authorization_response_model.dart';
import 'package:viserpay/data/model/global/response_model/response_model.dart';
import 'package:viserpay/data/model/savings/organaization_list_response_model.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';
import 'package:viserpay/data/repo/saving/saving_repo.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';

class SavingsController extends GetxController {
  final SavingRepo savingRepo;
  final NomineeController nomineeController;
  SavingsController({required this.savingRepo, required this.nomineeController});

  List<String> installmentAmountList = [];
  List<Interval> intervalList = [];
  List<Interval> tenureList = [];
  List<String> otpType = [];
  String details = "-1";
  String currencySym = "";
  String currency = "";
  String currentBalance = "";
  bool isLoading = false;

  Future<void> initializeData() async {
    currentBalance = savingRepo.apiClient.getBalance();
    details = "-1";
    selectedInstallmentAmount = null;
    selectedInterval = null;
    selectedTenure = null;
    installmentAmountList = [];
    intervalList = [];
    tenureList = [];
    isLoading = true;
    currencySym = savingRepo.apiClient.getCurrencyOrUsername(isSymbol: true);
    currency = savingRepo.apiClient.getCurrencyOrUsername(isCurrency: true);
    update();
    await getSavingsData();
  }

// get savings data
  Future<void> getSavingsData() async {
    try {
      ResponseModel response = await savingRepo.getSavingsData();
      if (response.statusCode == 200) {
        SavingsDataResponseModel model = SavingsDataResponseModel.fromJson(jsonDecode(response.responseJson));
        if (model.status == "success") {
          installmentAmountList = model.data?.installmentAmounts ?? [];
          intervalList = model.data?.intervals ?? [];
          tenureList = model.data?.tenures ?? [];
          otpType = model.data?.otpTypes ?? [];
          nomineeController.updateNomineeListAndImagePath(model.data?.nominee ?? [], imagePath: model.data?.nomineeImagePath);
          details = model.data?.policies?.description ?? "-1";
          if (installmentAmountList.isNotEmpty) {
            installmentAmountList.insert(0, MyStrings.selectOne);
            selectedInstallmentAmount = installmentAmountList.first;
          }
          if (intervalList.isNotEmpty) {
            intervalList.insert(0, Interval(id: "-1", name: MyStrings.selectOne));
            selectedInterval = intervalList.first;
          }
          if (tenureList.isNotEmpty) {
            tenureList.insert(0, Interval(id: "-1", name: MyStrings.selectOne));
            selectedTenure = tenureList.first;
          }
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [response.message]);
      }
    } catch (e) {
      printX(e);
    } finally {
      isLoading = false;
      update();
    }
  }

// select installment/interval/tenure
  String? selectedInstallmentAmount;
  Interval? selectedInterval;
  Interval? selectedTenure;

  selectInstallmentAmount(String installmentAmount) {
    if (installmentAmount != MyStrings.selectOne) {
      selectedInstallmentAmount = installmentAmount;
      update();
    }
  }

  selectInterval(Interval interval) {
    if (interval.id != "-1") {
      selectedInterval = interval;
      update();
    }
  }

  selectTenure(Interval tenure) {
    if (tenure.id != "-1") {
      selectedTenure = tenure;
      update();
    }
  }

  // get organization list
  bool isOrganizationListLoading = false;
  List<SavingBank> organizationList = [];
  String organizationImagePath = "";
  Future<void> getOrganizationList() async {
    try {
      isOrganizationListLoading = true;
      update();
      ResponseModel response = await savingRepo.getOrganizationList(
        tenorId: selectedTenure?.id ?? "",
        intervalId: selectedInterval?.id ?? "",
        installmentAmountId: StringConverter.formatNumber(selectedInstallmentAmount ?? "", precision: 0),
      );
      if (response.statusCode == 200) {
        OrganizationListResponseModel model = OrganizationListResponseModel.fromJson(jsonDecode(response.responseJson));
        if (model.status == "success") {
          organizationList = model.data?.organizationList ?? [];
          organizationImagePath = model.data?.organizationImagePath ?? "";

          if (organizationList.isNotEmpty) {
            // organizationList.insert(0, SavingBank(name: MyStrings.selectOne, id: "-1"));
            selectOrganization(organizationList.first);
            selectedOtpType = null;
            pinController.text = "";
            Get.toNamed(RouteHelper.savingsOrganizationsScreen);
          } else {
            CustomSnackBar.error(errorList: [MyStrings.noOrganizationFound]);
          }
        } else {
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        CustomSnackBar.error(errorList: [response.message]);
      }
    } catch (e) {
      printX(e);
    } finally {
      isOrganizationListLoading = false;
      update();
    }
  }

  List<DpsPlan> dpsPlanList = [];
  DpsPlan? selectedDpsPlan;
  selectDpsPlan(DpsPlan dpsPlan) {
    selectedDpsPlan = dpsPlan;
    update();
  }

  SavingBank? selectedOrganization;
  selectOrganization(SavingBank organization) {
    selectedOrganization = organization;
    dpsPlanList = organization.dpsPlans ?? [];
    selectedDpsPlan = null;
    update();
  }

  String? selectedOtpType;
  selectOtpType(String otpType) {
    selectedOtpType = otpType;
    update();
  }

  material.TextEditingController pinController = material.TextEditingController();
  material.FocusNode pinFocusNode = material.FocusNode();

  clearPinData() {
    pinController.text = "";
    selectedOtpType = null;
    update();
  }

  // submit dps plan
  bool isSubmitLoading = false;
  Future<void> submitDpsPlan() async {
    try {
      isSubmitLoading = true;
      update();
      ResponseModel response = await savingRepo.submitDpsPlan(nomineeId: Get.find<NomineeController>().selectedNominee?.id ?? "", dpsPlanId: selectedDpsPlan?.id ?? "", pin: pinController.text, otpType: selectedOtpType);

      if (response.statusCode == 200) {
        AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(response.responseJson));
        if (model.status == "success") {
          printX(model.data?.actionId);
          if (model.data?.actionId == 'null' || model.data?.actionId == null) {
            // Get.toNamed(RouteHelper.sendMoneySuccessScreen, arguments: [responseModel]);
            Get.toNamed(RouteHelper.bottomNavBar);
            CustomSnackBar.success(successList: model.message?.success ?? [MyStrings.success]);
          } else {
            Get.toNamed(
              RouteHelper.otpScreen,
              arguments: [
                model.data?.actionId,
                RouteHelper.bottomNavBar,
                pinController.text.toString(),
                selectedOtpType,
              ],
            );
          }
        } else {
          Get.back();
          CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
        }
      } else {
        Get.back();
        CustomSnackBar.error(errorList: [response.message]);
      }
    } catch (e) {
      printX(e);
      Get.back();
    } finally {
      isSubmitLoading = false;
      update();
    }
  }

  bool validatePinCode() {
    if (pinController.text.length != 4) {
      MyUtils.vibrate();
      CustomSnackBar.error(errorList: [MyStrings.pinLengthErrorMessage]);
      return false;
    }
    if (pinController.text.isEmpty) {
      MyUtils.vibrate();
      CustomSnackBar.error(errorList: [MyStrings.pinErrorMessage]);
      return false;
    }

    return true;
  }
}
